#ifndef _LED_H_
#define _LED_H_

#include "ht32f5xxxx_01.h"

#define	LED_PORT				HT_GPIOB
#define	LED_AFIO_PORT		GPIO_PB

#define	LED1_IO				GPIO_PIN_0		/* PB0 */
#define	LED2_IO		   	GPIO_PIN_1    /* PB1 */
#define	LED3_IO		   	GPIO_PIN_2    /* PB2 */
#define	LED4_IO		   	GPIO_PIN_3     /* PB3 */
#define	LEDP_IO		   	GPIO_PIN_12    /* PB12 */

#define	LED1_ON()			(LED_PORT->RR = LED1_IO)
#define	LED1_OFF()			(LED_PORT->SRR = LED1_IO)
#define	LED1_TOGGLE()		((LED_PORT->DOUTR & LED1_IO) ? LED1_ON() : LED1_OFF())
#define	LED2_ON()			(LED_PORT->RR = LED2_IO)
#define	LED2_OFF()			(LED_PORT->SRR = LED2_IO)
#define	LED2_TOGGLE()		((LED_PORT->DOUTR & LED2_IO) ? LED2_ON() : LED2_OFF())
#define	LED3_ON()			(LED_PORT->RR = LED3_IO)
#define	LED3_OFF()			(LED_PORT->SRR = LED3_IO)
#define	LED3_TOGGLE()		((LED_PORT->DOUTR & LED3_IO) ? LED3_ON() : LED3_OFF())
#define	LED4_ON()			(LED_PORT->RR = LED4_IO)
#define	LED4_OFF()			(LED_PORT->SRR = LED4_IO)
#define	LED4_TOGGLE()		((LED_PORT->DOUTR & LED4_IO) ? LED4_ON() : LED4_OFF())
#define	LEDP_ON()			(LED_PORT->RR = LEDP_IO)
#define	LEDP_OFF()			(LED_PORT->SRR = LEDP_IO)
#define	LEDP_TOGGLE()		((LED_PORT->DOUTR & LEDP_IO) ? LEDP_ON() : LEDP_OFF())

#define	MAX_LED_NUM		5
#define  LED1     		(1 << 0)
#define  LED2     		(1 << 1)
#define  LED3     		(1 << 2)
#define  LED4     		(1 << 3)
#define  LEDP     		(1 << 4)


void LED_IO_configure(void);
void LED_always_on(u8 led);
void LED_always_off(u8 led);
void LED_flash_enable(u8 led,u16 timer);
void LED_flash_process(void);

#endif /* _LED_H_ */
